///////////////////////////////
// Author : Guillaume Demesy //
// grating2D_materials.pro  //
///////////////////////////////

// To add a new material to the model, e.g. a 17-th:
// 1- increment nb_available_materials to 17
// 2- fill below:
//      lambdamat_17={};
//      epsr_mat_re_17={};
//      epsr_mat_im_17={};
//      since e^-iwt is assumed, passive materials have >0 imaginary part (epsr_mat_im_*)
// 3- append: to flag_mat_* in grating2D_data.geo:
//      16="your_material"
// 4- add in Function{} in grating2D.pro:
//      epsr_re_interp_mat_17[] = InterpolationLinear[$1]{ListAlt[lambdamat_17,epsr_mat_re_17]};
//      epsr_im_interp_mat_17[] = InterpolationLinear[$1]{ListAlt[lambdamat_17,epsr_mat_im_17]};

// all but superstrate 0="air",1="SiO2",2="Ag (palik)",3="Al (palik)",4="Au (johnson)",5="Nb2O5",6="ZnSe",7="MgF2",8="TiO2",9="PMMA",10="Si",11="ITO",12="Cu (palik)",13="custom 1",14="custom 2",15="custom 3"
// superstrate 0="air",1="SiO2",6="ZnSe",7="MgF2",8="TiO2",9="PMMA"
// 1_air
// 2_silicon_dioxide (palik)
// 3_silver_palik (palik)
// 4_alu_palik (palik)
// 5_gold_johnson (johnson & christie)
// 6_nb2o5 (refractiveindex.info)
// 7_ZnSe  (refractiveindex.info)
// 8_MgF2  (refractiveindex.info)
// 9_TiO2  (refractiveindex.info)
// 10_PMMA (refractiveindex.info)
// 11_Si (odp)
// 12_ITO
// 13_Cu
// 14_custom1
// 15_custom2
// 16_custom3
nb_available_materials = 16;
nb_available_lossless_materials = 7;
lossless_material_list={1,2,7,8,9,10,14};//0="air",1="SiO2",6="ZnSe",7="MgF2",8="TiO2",9="PMMA",13="custom 1"
lambdamat_1  = {1e-9,50e-6};
epsr_mat_re_1  = {1.0,1.0};
epsr_mat_im_1  = {0.,0.};
// lambdamat_2    = {1.984000e-07,3.243900e-06};
// epsr_mat_re_2  = {5,5};
// epsr_mat_im_2  = {0,0};
lambdamat_2    = {1.984000e-07,2.066000e-07,2.139000e-07,2.144000e-07,2.267000e-07,2.302000e-07,2.378000e-07,2.399000e-07,2.483000e-07,2.652000e-07,2.699000e-07,2.753000e-07,2.803000e-07,2.894000e-07,2.967000e-07,3.021000e-07,3.303000e-07,3.341000e-07,3.404000e-07,3.466000e-07,3.611000e-07,3.650000e-07,4.047000e-07,4.358000e-07,4.678000e-07,4.861000e-07,5.086000e-07,5.461000e-07,5.770000e-07,5.791000e-07,5.876000e-07,5.893000e-07,6.438000e-07,6.563000e-07,6.678000e-07,7.065000e-07,8.521000e-07,8.943000e-07,1.014000e-06,1.083000e-06,1.128700e-06,1.362200e-06,1.395100e-06,1.469500e-06,1.529500e-06,1.660600e-06,1.681000e-06,1.693200e-06,1.709100e-06,1.813100e-06,1.970100e-06,2.058100e-06,2.152600e-06,2.325400e-06,2.437400e-06,3.243900e-06};
epsr_mat_re_2  = {2.414916e+00,2.380849e+00,2.354076e+00,2.352236e+00,2.318920e+00,2.310704e+00,2.294316e+00,2.290380e+00,2.275271e+00,2.250000e+00,2.244304e+00,2.237717e+00,2.232036e+00,2.223081e+00,2.216228e+00,2.211764e+00,2.191880e+00,2.189808e+00,2.186258e+00,2.183006e+00,2.175920e+00,2.174150e+00,2.159724e+00,2.151209e+00,2.144174e+00,2.140662e+00,2.137152e+00,2.131892e+00,2.128389e+00,2.128097e+00,2.127222e+00,2.126931e+00,2.121975e+00,2.121101e+00,2.120227e+00,2.117316e+00,2.109756e+00,2.108014e+00,2.103370e+00,2.100760e+00,2.099311e+00,2.091494e+00,2.090338e+00,2.088025e+00,2.086002e+00,2.081383e+00,2.080518e+00,2.080229e+00,2.079652e+00,2.075616e+00,2.069282e+00,2.065544e+00,2.061522e+00,2.053202e+00,2.047475e+00,1.996852e+00};
epsr_mat_im_2  = {0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00,0.000000e+00};
lambdamat_3    = {2.988000e-07,3.024000e-07,3.061000e-07,3.100000e-07,3.115000e-07,3.139000e-07,3.155000e-07,3.179000e-07,3.195000e-07,3.220000e-07,3.237000e-07,3.263000e-07,3.306000e-07,3.324000e-07,3.351000e-07,3.397000e-07,3.444000e-07,3.542000e-07,3.647000e-07,3.757000e-07,3.875000e-07,4.000000e-07,4.133000e-07,4.275000e-07,4.428000e-07,4.592000e-07,4.769000e-07,4.959000e-07,5.166000e-07,5.391000e-07,5.636000e-07,5.904000e-07,6.199000e-07,6.526000e-07,6.888000e-07,7.293000e-07,7.749000e-07,8.266000e-07,8.856000e-07,9.537000e-07,1.033000e-06,1.127000e-06,1.240000e-06};
epsr_mat_re_3  = {1.332420e+00,1.460092e+00,1.463868e+00,1.331720e+00,1.209120e+00,1.028601e+00,8.257400e-01,6.146080e-01,3.875490e-01,1.820390e-01,8.575000e-03,-1.628930e-01,-5.233280e-01,-7.105630e-01,-8.857600e-01,-1.187319e+00,-1.480956e+00,-2.029919e+00,-2.557504e+00,-2.748900e+00,-3.239236e+00,-3.772571e+00,-4.422171e+00,-5.082000e+00,-5.735351e+00,-6.532864e+00,-7.380976e+00,-8.277500e+00,-9.408000e+00,-1.054586e+01,-1.188810e+01,-1.338096e+01,-1.503724e+01,-1.720290e+01,-1.969400e+01,-2.244570e+01,-2.588765e+01,-3.022897e+01,-3.537593e+01,-4.130570e+01,-4.880902e+01,-5.876590e+01,-7.197186e+01};
epsr_mat_im_3  = {3.019648e+00,2.638944e+00,2.193824e+00,1.711962e+00,1.460312e+00,1.240920e+00,1.073232e+00,9.394560e-01,8.573800e-01,8.000400e-01,7.502880e-01,6.974760e-01,6.032460e-01,5.790840e-01,5.797680e-01,5.801600e-01,5.902400e-01,6.019200e-01,5.989200e-01,6.680000e-01,6.950400e-01,6.747000e-01,7.300600e-01,7.232000e-01,7.536000e-01,7.372800e-01,7.180800e-01,7.488000e-01,7.982000e-01,8.385000e-01,8.280000e-01,8.857200e-01,1.016560e+00,1.162000e+00,1.243200e+00,1.403040e+00,1.455740e+00,1.595000e+00,1.939700e+00,2.546280e+00,3.159480e+00,3.850340e+00,5.586420e+00};
lambdamat_4    = {1.984000e-07,2.066000e-07,2.156000e-07,2.254000e-07,2.362000e-07,2.480000e-07,2.610000e-07,2.755000e-07,2.917000e-07,3.000000e-07,3.100000e-07,3.179000e-07,3.263000e-07,3.351000e-07,3.444000e-07,3.500000e-07,3.542000e-07,3.647000e-07,3.757000e-07,3.875000e-07,4.000000e-07,4.133000e-07,4.275000e-07,4.428000e-07,4.500000e-07,4.592000e-07,4.769000e-07,4.959000e-07,5.000000e-07,5.061000e-07,5.166000e-07,5.276000e-07,5.391000e-07,5.500000e-07,5.510000e-07,5.636000e-07,5.767000e-07,5.904000e-07,6.000000e-07,6.048000e-07,6.199000e-07,6.358000e-07,6.500000e-07,6.526000e-07,6.702000e-07,6.888000e-07,7.000000e-07,7.085000e-07,7.293000e-07,7.500000e-07,7.514000e-07,7.749000e-07,7.999000e-07,8.250000e-07,8.266000e-07,8.500000e-07,8.551000e-07,8.750000e-07,8.856000e-07,9.000000e-07,9.184000e-07,9.250000e-07,9.500000e-07,9.537000e-07,9.919000e-07,1.000000e-06,1.033000e-06,1.078000e-06,1.127000e-06,1.181000e-06,1.200000e-06,1.240000e-06,1.305000e-06,1.378000e-06,1.459000e-06,1.500000e-06,1.550000e-06,1.653000e-06,1.771000e-06,1.907000e-06,2.000000e-06};
epsr_mat_re_4  = {-5.184239e+00,-5.695200e+00,-6.280219e+00,-6.945575e+00,-7.754516e+00,-8.607500e+00,-9.628419e+00,-1.083571e+01,-1.225198e+01,-1.295592e+01,-1.390116e+01,-1.464950e+01,-1.549622e+01,-1.636526e+01,-1.725640e+01,-1.783698e+01,-1.834177e+01,-1.945925e+01,-2.060698e+01,-2.197250e+01,-2.337950e+01,-2.492687e+01,-2.672864e+01,-2.858680e+01,-2.953898e+01,-3.072166e+01,-3.315698e+01,-3.579087e+01,-3.637504e+01,-3.719998e+01,-3.875612e+01,-4.046471e+01,-4.207076e+01,-4.383834e+01,-4.396263e+01,-4.588210e+01,-4.783360e+01,-4.980000e+01,-5.126760e+01,-5.194770e+01,-5.426040e+01,-5.659040e+01,-5.852320e+01,-5.893230e+01,-6.160010e+01,-6.437650e+01,-6.570720e+01,-6.674400e+01,-6.886530e+01,-6.854440e+01,-6.849630e+01,-6.704310e+01,-6.356250e+01,-6.149360e+01,-6.154850e+01,-6.075630e+01,-6.074770e+01,-6.124800e+01,-6.238650e+01,-6.464640e+01,-6.777400e+01,-6.894720e+01,-7.663430e+01,-7.760610e+01,-8.818320e+01,-8.995390e+01,-9.841240e+01,-1.108959e+02,-1.240000e+02,-1.377759e+02,-1.425359e+02,-1.547859e+02,-1.727271e+02,-1.944124e+02,-2.202411e+02,-2.352556e+02,-2.539264e+02,-2.898819e+02,-3.317571e+02,-3.880799e+02,-4.238675e+02};
epsr_mat_im_4  = {5.426400e-01,6.214000e-01,7.078200e-01,8.184000e-01,9.597600e-01,1.117200e+00,1.299980e+00,1.537800e+00,1.832220e+00,1.992720e+00,2.199120e+00,2.380800e+00,2.575400e+00,2.793280e+00,3.035760e+00,3.180000e+00,3.311000e+00,3.606020e+00,3.939840e+00,4.333200e+00,4.762800e+00,5.250920e+00,5.803200e+00,6.434480e+00,6.760920e+00,7.187040e+00,8.062000e+00,9.105300e+00,9.351040e+00,9.704700e+00,1.037456e+01,1.113228e+01,1.194720e+01,1.281804e+01,1.290420e+01,1.397400e+01,1.512000e+01,1.644500e+01,1.742400e+01,1.783640e+01,1.944800e+01,2.126700e+01,2.290260e+01,2.330360e+01,2.563200e+01,2.857080e+01,3.041460e+01,3.204980e+01,3.667960e+01,4.137600e+01,4.154840e+01,4.523600e+01,4.732000e+01,4.570500e+01,4.553880e+01,4.290840e+01,4.236360e+01,3.893680e+01,3.678080e+01,3.419600e+01,3.139680e+01,3.005460e+01,2.646240e+01,2.828200e+01,2.600260e+01,2.586600e+01,2.520000e+01,2.565200e+01,2.688000e+01,2.855600e+01,2.904000e+01,3.025000e+01,3.247200e+01,3.528000e+01,3.963400e+01,4.250400e+01,4.608000e+01,5.437800e+01,6.478200e+01,7.880400e+01,8.901000e+01};
lambdamat_5    = {1.882406e-07,1.920229e-07,1.956516e-07,1.997408e-07,2.036702e-07,2.077572e-07,2.123740e-07,2.168216e-07,2.218550e-07,2.267131e-07,2.317888e-07,2.375503e-07,2.431288e-07,2.494755e-07,2.556354e-07,2.621072e-07,2.694985e-07,2.767011e-07,2.849514e-07,2.930160e-07,3.015505e-07,3.113754e-07,3.210305e-07,3.321893e-07,3.432011e-07,3.549680e-07,3.686611e-07,3.822732e-07,3.982013e-07,4.141293e-07,4.313847e-07,4.517774e-07,4.723908e-07,4.969552e-07,5.220117e-07,5.497292e-07,5.832807e-07,6.181034e-07,6.608446e-07,7.059022e-07,7.575536e-07,8.227735e-07,8.938043e-07,9.860222e-07,1.089814e-06,1.218027e-06,1.395941e-06,1.613491e-06,1.941231e-06};
epsr_mat_re_5  = {2.270560e-01,2.951910e-01,2.925240e-01,2.038990e-01,1.381710e-01,-1.041600e-02,-1.325000e-01,-2.337690e-01,-3.463290e-01,-4.155000e-01,-5.510090e-01,-6.168960e-01,-7.445290e-01,-8.912610e-01,-1.080444e+00,-1.236501e+00,-1.346409e+00,-1.366509e+00,-1.332261e+00,-1.306784e+00,-1.227421e+00,-1.242549e+00,-1.230804e+00,-1.355289e+00,-1.310241e+00,-1.231956e+00,-1.400625e+00,-1.604889e+00,-1.649404e+00,-1.702164e+00,-1.692204e+00,-1.731296e+00,-1.702701e+00,-2.278289e+00,-3.946161e+00,-5.842125e+00,-8.112669e+00,-1.066188e+01,-1.364821e+01,-1.681771e+01,-2.061016e+01,-2.581129e+01,-3.204067e+01,-4.027410e+01,-5.104960e+01,-6.621852e+01,-9.042646e+01,-1.253505e+02,-1.890420e+02};
epsr_mat_im_5  = {3.041280e+00,3.175920e+00,3.285680e+00,3.327660e+00,3.396820e+00,3.390400e+00,3.510000e+00,3.606200e+00,3.710200e+00,3.825200e+00,3.892200e+00,4.055040e+00,4.163280e+00,4.338460e+00,4.490080e+00,4.722300e+00,4.976280e+00,5.282420e+00,5.494860e+00,5.596440e+00,5.780340e+00,5.792580e+00,5.845840e+00,5.573680e+00,5.538160e+00,5.598000e+00,5.609200e+00,5.644360e+00,5.738880e+00,5.717360e+00,5.649200e+00,5.320920e+00,4.844380e+00,3.812640e+00,2.580440e+00,2.111300e+00,1.660540e+00,1.374240e+00,1.035160e+00,1.066780e+00,1.271760e+00,1.626560e+00,1.925420e+00,2.794000e+00,3.861000e+00,5.701500e+00,8.186340e+00,1.255520e+01,2.535520e+01};
lambdamat_6    = {2.50000e-07,2.55000e-07,2.60000e-07,2.65000e-07,2.70000e-07,2.75000e-07,2.80000e-07,2.85000e-07,2.90000e-07,2.95000e-07,3.00000e-07,3.05000e-07,3.10000e-07,3.15000e-07,3.20000e-07,3.25000e-07,3.30000e-07,3.35000e-07,3.40000e-07,3.45000e-07,3.50000e-07,3.55000e-07,3.60000e-07,3.65000e-07,3.70000e-07,3.75000e-07,3.80000e-07,3.85000e-07,3.90000e-07,3.95000e-07,4.00000e-07,4.05000e-07,4.10000e-07,4.15000e-07,4.20000e-07,4.25000e-07,4.30000e-07,4.35000e-07,4.40000e-07,4.45000e-07,4.50000e-07,4.55000e-07,4.60000e-07,4.65000e-07,4.70000e-07,4.75000e-07,4.80000e-07,4.85000e-07,4.90000e-07,4.95000e-07,5.00000e-07,5.05000e-07,5.10000e-07,5.15000e-07,5.20000e-07,5.25000e-07,5.30000e-07,5.35000e-07,5.40000e-07,5.45000e-07,5.50000e-07,5.55000e-07,5.60000e-07,5.65000e-07,5.70000e-07,5.75000e-07,5.80000e-07,5.85000e-07,5.90000e-07,5.95000e-07,6.00000e-07,6.05000e-07,6.10000e-07,6.15000e-07,6.20000e-07,6.25000e-07,6.30000e-07,6.35000e-07,6.40000e-07,6.45000e-07,6.50000e-07,6.55000e-07,6.60000e-07,6.65000e-07,6.70000e-07,6.75000e-07,6.80000e-07,6.85000e-07,6.90000e-07,6.95000e-07,7.00000e-07,7.05000e-07,7.10000e-07,7.15000e-07,7.20000e-07,7.25000e-07,7.30000e-07,7.35000e-07,7.40000e-07,7.45000e-07,7.50000e-07,7.55000e-07,7.60000e-07,7.65000e-07,7.70000e-07,7.75000e-07,7.80000e-07,7.85000e-07,7.90000e-07,7.95000e-07,8.00000e-07,8.05000e-07,8.10000e-07,8.15000e-07,8.20000e-07,8.25000e-07,8.30000e-07,8.35000e-07,8.40000e-07,8.45000e-07,8.50000e-07,8.55000e-07,8.60000e-07,8.65000e-07,8.70000e-07,8.75000e-07,8.80000e-07,8.85000e-07,8.90000e-07,8.95000e-07,9.00000e-07,9.05000e-07,9.10000e-07,9.15000e-07,9.20000e-07,9.25000e-07,9.30000e-07,9.35000e-07,9.40000e-07,9.45000e-07,9.50000e-07,9.55000e-07,9.60000e-07,9.65000e-07,9.70000e-07,9.75000e-07,9.80000e-07,9.85000e-07,9.90000e-07,9.95000e-07,1.00000e-06,1.00500e-06,1.01000e-06,1.01500e-06,1.02000e-06,1.02500e-06,1.03000e-06,1.03500e-06,1.04000e-06,1.04500e-06,1.05000e-06,1.05500e-06,1.06000e-06,1.06500e-06,1.07000e-06,1.07500e-06,1.08000e-06,1.08500e-06,1.09000e-06,1.09500e-06,1.10000e-06,1.10500e-06,1.11000e-06,1.11500e-06,1.12000e-06,1.12500e-06,1.13000e-06,1.13500e-06,1.14000e-06,1.14500e-06,1.15000e-06,1.15500e-06,1.16000e-06,1.16500e-06,1.17000e-06,1.17500e-06,1.18000e-06,1.18500e-06,1.19000e-06,1.19500e-06,1.20000e-06,1.20500e-06,1.21000e-06,1.21500e-06,1.22000e-06,1.22500e-06,1.23000e-06,1.23500e-06,1.24000e-06,1.24500e-06,1.25000e-06,1.25500e-06,1.26000e-06,1.26500e-06,1.27000e-06,1.27500e-06,1.28000e-06,1.28500e-06,1.29000e-06,1.29500e-06,1.30000e-06,1.30500e-06,1.31000e-06,1.31500e-06,1.32000e-06,1.32500e-06,1.33000e-06,1.33500e-06,1.34000e-06,1.34500e-06,1.35000e-06,1.35500e-06,1.36000e-06,1.36500e-06,1.37000e-06,1.37500e-06,1.38000e-06,1.38500e-06,1.39000e-06,1.39500e-06,1.40000e-06,1.40500e-06,1.41000e-06,1.41500e-06,1.42000e-06,1.42500e-06,1.43000e-06,1.43500e-06,1.44000e-06,1.44500e-06,1.45000e-06,1.45500e-06,1.46000e-06,1.46500e-06,1.47000e-06,1.47500e-06,1.48000e-06,1.48500e-06,1.49000e-06,1.49500e-06,1.50000e-06,1.50500e-06,1.51000e-06,1.51500e-06,1.52000e-06,1.52500e-06,1.53000e-06,1.53500e-06,1.54000e-06,1.54500e-06,1.55000e-06,1.55500e-06,1.56000e-06,1.56500e-06,1.57000e-06,1.57500e-06,1.58000e-06,1.58500e-06,1.59000e-06,1.59500e-06,1.60000e-06,1.60500e-06,1.61000e-06,1.61500e-06,1.62000e-06,1.62500e-06,1.63000e-06,1.63500e-06,1.64000e-06,1.64500e-06,1.65000e-06,1.65500e-06,1.66000e-06,1.66500e-06,1.67000e-06,1.67500e-06,1.68000e-06,1.68500e-06,1.69000e-06,1.69500e-06,1.70000e-06,1.70500e-06,1.71000e-06,1.71500e-06,1.72000e-06,1.72500e-06,1.73000e-06,1.73500e-06,1.74000e-06,1.74500e-06,1.75000e-06,1.75500e-06,1.76000e-06,1.76500e-06,1.77000e-06,1.77500e-06,1.78000e-06,1.78500e-06,1.79000e-06,1.79500e-06,1.80000e-06,1.80500e-06,1.81000e-06,1.81500e-06,1.82000e-06,1.82500e-06,1.83000e-06,1.83500e-06,1.84000e-06,1.84500e-06,1.85000e-06,1.85500e-06,1.86000e-06,1.86500e-06,1.87000e-06,1.87500e-06,1.88000e-06,1.88500e-06,1.89000e-06,1.89500e-06,1.90000e-06,1.90500e-06,1.91000e-06,1.91500e-06,1.92000e-06,1.92500e-06,1.93000e-06,1.93500e-06,1.94000e-06,1.94500e-06,1.95000e-06,1.95500e-06,1.96000e-06,1.96500e-06,1.97000e-06,1.97500e-06,1.98000e-06,1.98500e-06,1.99000e-06,1.99500e-06,2.00000e-06,2.00500e-06,2.01000e-06,2.01500e-06,2.02000e-06,2.02500e-06,2.03000e-06,2.03500e-06,2.04000e-06,2.04500e-06,2.05000e-06,2.05500e-06,2.06000e-06,2.06500e-06,2.07000e-06,2.07500e-06,2.08000e-06,2.08500e-06,2.09000e-06,2.09500e-06,2.10000e-06,2.10500e-06,2.11000e-06,2.11500e-06,2.12000e-06,2.12500e-06,2.13000e-06,2.13500e-06,2.14000e-06,2.14500e-06,2.15000e-06,2.15500e-06,2.16000e-06,2.16500e-06,2.17000e-06,2.17500e-06,2.18000e-06,2.18500e-06,2.19000e-06,2.19500e-06,2.20000e-06,2.20500e-06,2.21000e-06,2.21500e-06,2.22000e-06,2.22500e-06,2.23000e-06,2.23500e-06,2.24000e-06,2.24500e-06,2.25000e-06,2.25500e-06,2.26000e-06,2.26500e-06,2.27000e-06,2.27500e-06,2.28000e-06,2.28500e-06,2.29000e-06,2.29500e-06,2.30000e-06,2.30500e-06,2.31000e-06,2.31500e-06,2.32000e-06,2.32500e-06,2.33000e-06,2.33500e-06,2.34000e-06,2.34500e-06,2.35000e-06,2.35500e-06,2.36000e-06,2.36500e-06,2.37000e-06,2.37500e-06,2.38000e-06,2.38500e-06,2.39000e-06,2.39500e-06,2.40000e-06,2.40500e-06,2.41000e-06,2.41500e-06,2.42000e-06,2.42500e-06,2.43000e-06,2.43500e-06,2.44000e-06,2.44500e-06,2.45000e-06,2.45500e-06,2.46000e-06,2.46500e-06,2.47000e-06,2.47500e-06,2.48000e-06,2.48500e-06,2.49000e-06,2.49500e-06,2.50000e-06};
epsr_mat_re_6  = {8.16792e+00,8.49945e+00,8.78466e+00,9.02184e+00,9.21036e+00,9.35052e+00,9.44356e+00,9.49148e+00,9.49695e+00,9.46318e+00,9.39377e+00,9.29260e+00,9.16375e+00,9.01136e+00,8.83960e+00,8.65260e+00,8.45441e+00,8.24904e+00,8.04041e+00,7.83249e+00,7.62939e+00,7.43568e+00,7.25738e+00,7.10698e+00,6.98302e+00,6.87490e+00,6.77864e+00,6.69186e+00,6.61293e+00,6.54066e+00,6.47411e+00,6.41256e+00,6.35542e+00,6.30218e+00,6.25243e+00,6.20581e+00,6.16204e+00,6.12084e+00,6.08199e+00,6.04529e+00,6.01056e+00,5.97765e+00,5.94641e+00,5.91672e+00,5.88847e+00,5.86155e+00,5.83587e+00,5.81136e+00,5.78793e+00,5.76552e+00,5.74406e+00,5.72350e+00,5.70378e+00,5.68484e+00,5.66666e+00,5.64918e+00,5.63237e+00,5.61618e+00,5.60060e+00,5.58558e+00,5.57110e+00,5.55712e+00,5.54363e+00,5.53061e+00,5.51802e+00,5.50585e+00,5.49407e+00,5.48268e+00,5.47166e+00,5.46098e+00,5.45062e+00,5.44059e+00,5.43087e+00,5.42143e+00,5.41227e+00,5.40338e+00,5.39475e+00,5.38636e+00,5.37822e+00,5.37029e+00,5.36259e+00,5.35510e+00,5.34780e+00,5.34071e+00,5.33380e+00,5.32708e+00,5.32052e+00,5.31414e+00,5.30792e+00,5.30185e+00,5.29594e+00,5.29017e+00,5.28455e+00,5.27905e+00,5.27370e+00,5.26846e+00,5.26335e+00,5.25837e+00,5.25349e+00,5.24873e+00,5.24408e+00,5.23953e+00,5.23509e+00,5.23074e+00,5.22649e+00,5.22233e+00,5.21826e+00,5.21428e+00,5.21038e+00,5.20657e+00,5.20283e+00,5.19918e+00,5.19559e+00,5.19209e+00,5.18865e+00,5.18528e+00,5.18198e+00,5.17875e+00,5.17558e+00,5.17247e+00,5.16942e+00,5.16643e+00,5.16350e+00,5.16063e+00,5.15780e+00,5.15504e+00,5.15232e+00,5.14965e+00,5.14704e+00,5.14447e+00,5.14195e+00,5.13947e+00,5.13704e+00,5.13465e+00,5.13230e+00,5.12999e+00,5.12773e+00,5.12550e+00,5.12331e+00,5.12116e+00,5.11905e+00,5.11697e+00,5.11493e+00,5.11292e+00,5.11095e+00,5.10901e+00,5.10709e+00,5.10521e+00,5.10337e+00,5.10155e+00,5.09976e+00,5.09800e+00,5.09627e+00,5.09456e+00,5.09288e+00,5.09123e+00,5.08960e+00,5.08800e+00,5.08642e+00,5.08487e+00,5.08334e+00,5.08183e+00,5.08035e+00,5.07889e+00,5.07745e+00,5.07603e+00,5.07463e+00,5.07326e+00,5.07190e+00,5.07056e+00,5.06924e+00,5.06794e+00,5.06666e+00,5.06540e+00,5.06416e+00,5.06293e+00,5.06172e+00,5.06052e+00,5.05935e+00,5.05819e+00,5.05704e+00,5.05591e+00,5.05480e+00,5.05370e+00,5.05262e+00,5.05155e+00,5.05050e+00,5.04945e+00,5.04843e+00,5.04741e+00,5.04642e+00,5.04543e+00,5.04445e+00,5.04349e+00,5.04254e+00,5.04161e+00,5.04068e+00,5.03976e+00,5.03886e+00,5.03797e+00,5.03709e+00,5.03622e+00,5.03537e+00,5.03452e+00,5.03368e+00,5.03286e+00,5.03204e+00,5.03123e+00,5.03043e+00,5.02965e+00,5.02887e+00,5.02810e+00,5.02734e+00,5.02660e+00,5.02585e+00,5.02512e+00,5.02439e+00,5.02368e+00,5.02297e+00,5.02227e+00,5.02158e+00,5.02090e+00,5.02022e+00,5.01955e+00,5.01889e+00,5.01824e+00,5.01760e+00,5.01696e+00,5.01633e+00,5.01571e+00,5.01509e+00,5.01448e+00,5.01387e+00,5.01328e+00,5.01269e+00,5.01210e+00,5.01152e+00,5.01095e+00,5.01039e+00,5.00983e+00,5.00928e+00,5.00873e+00,5.00819e+00,5.00765e+00,5.00712e+00,5.00659e+00,5.00608e+00,5.00556e+00,5.00505e+00,5.00455e+00,5.00405e+00,5.00356e+00,5.00307e+00,5.00259e+00,5.00211e+00,5.00164e+00,5.00117e+00,5.00071e+00,5.00025e+00,4.99979e+00,4.99934e+00,4.99890e+00,4.99846e+00,4.99802e+00,4.99759e+00,4.99716e+00,4.99674e+00,4.99632e+00,4.99590e+00,4.99549e+00,4.99508e+00,4.99468e+00,4.99427e+00,4.99388e+00,4.99349e+00,4.99310e+00,4.99271e+00,4.99233e+00,4.99195e+00,4.99158e+00,4.99121e+00,4.99084e+00,4.99047e+00,4.99011e+00,4.98976e+00,4.98940e+00,4.98905e+00,4.98871e+00,4.98836e+00,4.98802e+00,4.98768e+00,4.98734e+00,4.98701e+00,4.98668e+00,4.98636e+00,4.98603e+00,4.98571e+00,4.98540e+00,4.98508e+00,4.98477e+00,4.98446e+00,4.98415e+00,4.98385e+00,4.98354e+00,4.98324e+00,4.98295e+00,4.98265e+00,4.98236e+00,4.98207e+00,4.98179e+00,4.98151e+00,4.98123e+00,4.98094e+00,4.98067e+00,4.98040e+00,4.98012e+00,4.97985e+00,4.97958e+00,4.97932e+00,4.97906e+00,4.97879e+00,4.97853e+00,4.97828e+00,4.97803e+00,4.97777e+00,4.97752e+00,4.97727e+00,4.97703e+00,4.97678e+00,4.97654e+00,4.97630e+00,4.97606e+00,4.97582e+00,4.97559e+00,4.97535e+00,4.97513e+00,4.97489e+00,4.97467e+00,4.97444e+00,4.97422e+00,4.97400e+00,4.97377e+00,4.97356e+00,4.97334e+00,4.97312e+00,4.97291e+00,4.97270e+00,4.97249e+00,4.97228e+00,4.97207e+00,4.97187e+00,4.97166e+00,4.97146e+00,4.97126e+00,4.97106e+00,4.97086e+00,4.97067e+00,4.97047e+00,4.97028e+00,4.97009e+00,4.96989e+00,4.96970e+00,4.96952e+00,4.96933e+00,4.96915e+00,4.96896e+00,4.96878e+00,4.96860e+00,4.96842e+00,4.96824e+00,4.96806e+00,4.96789e+00,4.96771e+00,4.96754e+00,4.96737e+00,4.96720e+00,4.96703e+00,4.96686e+00,4.96669e+00,4.96652e+00,4.96636e+00,4.96619e+00,4.96603e+00,4.96587e+00,4.96571e+00,4.96555e+00,4.96539e+00,4.96524e+00,4.96508e+00,4.96492e+00,4.96477e+00,4.96462e+00,4.96447e+00,4.96432e+00,4.96417e+00,4.96402e+00,4.96387e+00,4.96373e+00,4.96358e+00,4.96344e+00,4.96329e+00,4.96315e+00,4.96301e+00,4.96287e+00,4.96273e+00,4.96259e+00,4.96245e+00,4.96231e+00,4.96218e+00,4.96204e+00,4.96191e+00,4.96177e+00,4.96164e+00,4.96151e+00,4.96138e+00,4.96125e+00,4.96112e+00,4.96099e+00,4.96087e+00,4.96074e+00,4.96061e+00,4.96049e+00,4.96036e+00,4.96024e+00,4.96012e+00,4.96000e+00,4.95988e+00,4.95976e+00,4.95964e+00,4.95952e+00,4.95940e+00,4.95928e+00,4.95916e+00,4.95905e+00,4.95893e+00,4.95882e+00,4.95871e+00,4.95859e+00,4.95848e+00,4.95837e+00,4.95826e+00,4.95815e+00,4.95804e+00,4.95793e+00,4.95782e+00,4.95772e+00,4.95761e+00,4.95750e+00,4.95740e+00,4.95729e+00,4.95719e+00};
epsr_mat_im_6  = {6.48929e+00,6.10134e+00,5.69030e+00,5.26264e+00,4.82486e+00,4.38328e+00,3.94390e+00,3.51230e+00,3.09350e+00,2.69192e+00,2.31136e+00,1.95497e+00,1.62528e+00,1.32424e+00,1.05326e+00,8.13245e-01,6.04705e-01,4.27761e-01,2.88463e-01,1.95916e-01,1.34565e-01,9.34290e-02,6.55391e-02,4.64348e-02,3.32115e-02,2.39756e-02,1.74544e-02,1.28205e-02,9.48906e-03,7.07908e-03,5.32294e-03,4.02636e-03,3.07057e-03,2.35477e-03,1.82035e-03,1.41497e-03,1.10713e-03,8.70860e-04,6.90528e-04,5.45835e-04,4.36393e-04,3.52069e-04,2.82869e-04,2.28648e-04,1.89276e-04,1.54948e-04,1.25619e-04,1.06070e-04,8.66092e-05,7.20345e-05,6.23136e-05,4.78477e-05,4.29886e-05,3.33801e-05,2.85657e-05,2.37680e-05,2.37326e-05,1.89588e-05,1.41994e-05,1.41803e-05,1.41619e-05,9.42942e-06,9.41797e-06,9.40690e-06,4.69809e-06,4.69291e-06,4.68789e-06,4.68303e-06,4.67831e-06,4.67375e-06,4.66931e-06,4.66502e-06,4.66084e-06,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00};
lambdamat_7    = {3.80000e-07,5.59300e-07,5.79400e-07,6.00100e-07,6.21600e-07,6.43800e-07,6.66900e-07,6.90800e-07,7.15500e-07,7.41100e-07,7.67600e-07,7.95100e-07,8.23600e-07,8.53100e-07,8.83600e-07,9.15300e-07,9.48000e-07,9.82000e-07,1.01700e-06,1.05400e-06,1.09100e-06,1.13000e-06,1.17100e-06,1.21300e-06,1.25600e-06,1.30100e-06,1.34800e-06,1.39600e-06,1.44600e-06,1.49800e-06,1.55100e-06,1.60700e-06,1.66400e-06,1.72400e-06,1.78600e-06,1.85000e-06,1.91600e-06,1.98400e-06,2.05500e-06,2.12900e-06,2.20500e-06,2.28400e-06,2.36600e-06,2.45100e-06,2.53800e-06,2.62900e-06,2.72300e-06,2.82100e-06,2.92200e-06,3.02700e-06,3.13500e-06,3.24700e-06,3.36300e-06,3.48400e-06,3.60900e-06,3.73800e-06,3.87200e-06,4.01000e-06,4.15400e-06,4.30300e-06,4.45700e-06,4.61600e-06,4.78100e-06,4.95300e-06,5.13000e-06,5.31400e-06,5.50400e-06,5.70100e-06,5.90500e-06,6.11600e-06,6.33500e-06,6.56200e-06,6.79700e-06,7.04000e-06,7.29200e-06,7.55400e-06,7.82400e-06,8.10400e-06,8.39400e-06,8.69500e-06,9.00600e-06,9.32900e-06,9.66200e-06,1.00100e-05,1.03700e-05,1.07400e-05,1.11200e-05,1.15200e-05,1.19300e-05,1.23600e-05,1.28000e-05,1.32600e-05,1.37400e-05,1.42300e-05,1.47400e-05,1.52600e-05,1.58100e-05,1.63800e-05,1.69600e-05,1.75700e-05,1.82000e-05};
epsr_mat_re_7  = {7.15780e+00,7.03333e+00,6.92594e+00,6.83315e+00,6.75148e+00,6.67943e+00,6.61496e+00,6.55730e+00,6.50555e+00,6.45877e+00,6.41641e+00,6.37783e+00,6.34267e+00,6.31059e+00,6.28129e+00,6.25435e+00,6.22971e+00,6.20698e+00,6.18618e+00,6.16663e+00,6.14922e+00,6.13283e+00,6.11746e+00,6.10341e+00,6.09055e+00,6.07849e+00,6.06722e+00,6.05691e+00,6.04727e+00,6.03827e+00,6.03003e+00,6.02220e+00,6.01502e+00,6.00821e+00,6.00187e+00,5.99596e+00,5.99044e+00,5.98530e+00,5.98043e+00,5.97581e+00,5.97150e+00,5.96742e+00,5.96355e+00,5.95987e+00,5.95641e+00,5.95308e+00,5.94990e+00,5.94683e+00,5.94388e+00,5.94102e+00,5.93826e+00,5.93556e+00,5.93291e+00,5.93029e+00,5.92769e+00,5.92512e+00,5.92253e+00,5.91995e+00,5.91732e+00,5.91465e+00,5.91193e+00,5.90916e+00,5.90629e+00,5.90330e+00,5.90022e+00,5.89700e+00,5.89365e+00,5.89012e+00,5.88641e+00,5.88250e+00,5.87836e+00,5.87397e+00,5.86932e+00,5.86437e+00,5.85909e+00,5.85344e+00,5.84743e+00,5.84099e+00,5.83409e+00,5.82668e+00,5.81874e+00,5.81020e+00,5.80105e+00,5.79111e+00,5.78041e+00,5.76897e+00,5.75673e+00,5.74330e+00,5.72894e+00,5.71320e+00,5.69636e+00,5.67794e+00,5.65779e+00,5.63623e+00,5.61266e+00,5.58741e+00,5.55930e+00,5.52859e+00,5.49560e+00,5.45892e+00,5.41878e+00};
epsr_mat_im_7  = {0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00};
lambdamat_8    = {1.40000e-07,1.45700e-07,1.51600e-07,1.57800e-07,1.64200e-07,1.70800e-07,1.77800e-07,1.85000e-07,1.92500e-07,2.00300e-07,2.08500e-07,2.16900e-07,2.25700e-07,2.34900e-07,2.44400e-07,2.54400e-07,2.64700e-07,2.75500e-07,2.86600e-07,2.98300e-07,3.10400e-07,3.23000e-07,3.36100e-07,3.49800e-07,3.64000e-07,3.78800e-07,3.94100e-07,4.10100e-07,4.26800e-07,4.44100e-07,4.62200e-07,4.80900e-07,5.00500e-07,5.20800e-07,5.42000e-07,5.64000e-07,5.86900e-07,6.10700e-07,6.35500e-07,6.61300e-07,6.88200e-07,7.16100e-07,7.45200e-07,7.75500e-07,8.07000e-07,8.39700e-07,8.73900e-07,9.09300e-07,9.46300e-07,9.84700e-07,1.02500e-06,1.06600e-06,1.11000e-06,1.15500e-06,1.20200e-06,1.25000e-06,1.30100e-06,1.35400e-06,1.40900e-06,1.46600e-06,1.52600e-06,1.58800e-06,1.65200e-06,1.71900e-06,1.78900e-06,1.86200e-06,1.93700e-06,2.01600e-06,2.09800e-06,2.18300e-06,2.27200e-06,2.36400e-06,2.46000e-06,2.56000e-06,2.66400e-06,2.77200e-06,2.88500e-06,3.00200e-06,3.12400e-06,3.25100e-06,3.38300e-06,3.52000e-06,3.66300e-06,3.81200e-06,3.96700e-06,4.12800e-06,4.29500e-06,4.47000e-06,4.65100e-06,4.84000e-06,5.03700e-06,5.24200e-06,5.45400e-06,5.67600e-06,5.90600e-06,6.14600e-06,6.39600e-06,6.65600e-06,6.92600e-06,7.20700e-06,7.50000e-06};
epsr_mat_re_8  = {2.26028e+00,2.21599e+00,2.17868e+00,2.14646e+00,2.11891e+00,2.09516e+00,2.07400e+00,2.05562e+00,2.03936e+00,2.02494e+00,2.01197e+00,2.00057e+00,1.99026e+00,1.98096e+00,1.97265e+00,1.96505e+00,1.95825e+00,1.95204e+00,1.94647e+00,1.94134e+00,1.93669e+00,1.93245e+00,1.92858e+00,1.92502e+00,1.92178e+00,1.91880e+00,1.91608e+00,1.91358e+00,1.91127e+00,1.90915e+00,1.90718e+00,1.90538e+00,1.90371e+00,1.90217e+00,1.90073e+00,1.89940e+00,1.89817e+00,1.89702e+00,1.89594e+00,1.89493e+00,1.89398e+00,1.89309e+00,1.89224e+00,1.89144e+00,1.89067e+00,1.88994e+00,1.88923e+00,1.88855e+00,1.88788e+00,1.88723e+00,1.88658e+00,1.88595e+00,1.88531e+00,1.88467e+00,1.88402e+00,1.88337e+00,1.88269e+00,1.88199e+00,1.88127e+00,1.88052e+00,1.87973e+00,1.87891e+00,1.87804e+00,1.87713e+00,1.87615e+00,1.87511e+00,1.87401e+00,1.87282e+00,1.87155e+00,1.87019e+00,1.86872e+00,1.86715e+00,1.86545e+00,1.86362e+00,1.86164e+00,1.85951e+00,1.85719e+00,1.85470e+00,1.85199e+00,1.84905e+00,1.84588e+00,1.84244e+00,1.83870e+00,1.83464e+00,1.83022e+00,1.82544e+00,1.82025e+00,1.81458e+00,1.80844e+00,1.80173e+00,1.79441e+00,1.78643e+00,1.77779e+00,1.76829e+00,1.75797e+00,1.74665e+00,1.73426e+00,1.72070e+00,1.70586e+00,1.68958e+00,1.67166e+00};
epsr_mat_im_8  = {0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00};
lambdamat_9    = {4.30000e-07,4.41000e-07,4.52000e-07,4.63000e-07,4.74000e-07,4.85000e-07,4.96000e-07,5.07000e-07,5.18000e-07,5.29000e-07,5.40000e-07,5.51000e-07,5.62000e-07,5.73000e-07,5.84000e-07,5.95000e-07,6.06000e-07,6.17000e-07,6.28000e-07,6.39000e-07,6.50000e-07,6.61000e-07,6.72000e-07,6.83000e-07,6.94000e-07,7.05000e-07,7.16000e-07,7.27000e-07,7.38000e-07,7.49000e-07,7.60000e-07,7.71000e-07,7.82000e-07,7.93000e-07,8.04000e-07,8.15000e-07,8.26000e-07,8.37000e-07,8.48000e-07,8.59000e-07,8.70000e-07,8.81000e-07,8.92000e-07,9.03000e-07,9.14000e-07,9.25000e-07,9.36000e-07,9.47000e-07,9.58000e-07,9.69000e-07,9.80000e-07,9.91000e-07,1.00200e-06,1.01300e-06,1.02400e-06,1.03500e-06,1.04600e-06,1.05700e-06,1.06800e-06,1.07900e-06,1.09000e-06,1.10100e-06,1.11200e-06,1.12300e-06,1.13400e-06,1.14500e-06,1.15600e-06,1.16700e-06,1.17800e-06,1.18900e-06,1.20000e-06,1.21100e-06,1.22200e-06,1.23300e-06,1.24400e-06,1.25500e-06,1.26600e-06,1.27700e-06,1.28800e-06,1.29900e-06,1.31000e-06,1.32100e-06,1.33200e-06,1.34300e-06,1.35400e-06,1.36500e-06,1.37600e-06,1.38700e-06,1.39800e-06,1.40900e-06,1.42000e-06,1.43100e-06,1.44200e-06,1.45300e-06,1.46400e-06,1.47500e-06,1.48600e-06,1.49700e-06,1.50800e-06,1.51900e-06,1.53000e-06};
epsr_mat_re_9  = {8.24665e+00,8.05083e+00,7.88148e+00,7.73370e+00,7.60372e+00,7.48860e+00,7.38600e+00,7.29405e+00,7.21124e+00,7.13631e+00,7.06823e+00,7.00614e+00,6.94932e+00,6.89716e+00,6.84912e+00,6.80477e+00,6.76371e+00,6.72561e+00,6.69018e+00,6.65716e+00,6.62633e+00,6.59748e+00,6.57045e+00,6.54507e+00,6.52122e+00,6.49876e+00,6.47758e+00,6.45759e+00,6.43869e+00,6.42080e+00,6.40385e+00,6.38777e+00,6.37250e+00,6.35799e+00,6.34418e+00,6.33103e+00,6.31850e+00,6.30654e+00,6.29512e+00,6.28421e+00,6.27377e+00,6.26379e+00,6.25422e+00,6.24506e+00,6.23627e+00,6.22784e+00,6.21974e+00,6.21196e+00,6.20448e+00,6.19728e+00,6.19035e+00,6.18369e+00,6.17726e+00,6.17107e+00,6.16510e+00,6.15934e+00,6.15377e+00,6.14840e+00,6.14321e+00,6.13820e+00,6.13335e+00,6.12865e+00,6.12411e+00,6.11972e+00,6.11546e+00,6.11134e+00,6.10734e+00,6.10347e+00,6.09971e+00,6.09606e+00,6.09252e+00,6.08909e+00,6.08575e+00,6.08252e+00,6.07937e+00,6.07631e+00,6.07333e+00,6.07044e+00,6.06763e+00,6.06489e+00,6.06222e+00,6.05963e+00,6.05710e+00,6.05464e+00,6.05225e+00,6.04991e+00,6.04763e+00,6.04541e+00,6.04325e+00,6.04114e+00,6.03908e+00,6.03707e+00,6.03511e+00,6.03319e+00,6.03132e+00,6.02950e+00,6.02771e+00,6.02597e+00,6.02427e+00,6.02261e+00,6.02098e+00};
epsr_mat_im_9  = {0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00};
lambdamat_10   = {4.04700e-07,4.11500e-07,4.18300e-07,4.25000e-07,4.31800e-07,4.38600e-07,4.45400e-07,4.52200e-07,4.59000e-07,4.65700e-07,4.72500e-07,4.79300e-07,4.86100e-07,4.92900e-07,4.99700e-07,5.06400e-07,5.13200e-07,5.20000e-07,5.26800e-07,5.33600e-07,5.40400e-07,5.47100e-07,5.53900e-07,5.60700e-07,5.67500e-07,5.74300e-07,5.81100e-07,5.87800e-07,5.94600e-07,6.01400e-07,6.08200e-07,6.15000e-07,6.21800e-07,6.28500e-07,6.35300e-07,6.42100e-07,6.48900e-07,6.55700e-07,6.62500e-07,6.69200e-07,6.76000e-07,6.82800e-07,6.89600e-07,6.96400e-07,7.03200e-07,7.09900e-07,7.16700e-07,7.23500e-07,7.30300e-07,7.37100e-07,7.43900e-07,7.50600e-07,7.57400e-07,7.64200e-07,7.71000e-07,7.77800e-07,7.84500e-07,7.91300e-07,7.98100e-07,8.04900e-07,8.11700e-07,8.18500e-07,8.25200e-07,8.32000e-07,8.38800e-07,8.45600e-07,8.52400e-07,8.59200e-07,8.65900e-07,8.72700e-07,8.79500e-07,8.86300e-07,8.93100e-07,8.99900e-07,9.06600e-07,9.13400e-07,9.20200e-07,9.27000e-07,9.33800e-07,9.40600e-07,9.47300e-07,9.54100e-07,9.60900e-07,9.67700e-07,9.74500e-07,9.81300e-07,9.88000e-07,9.94800e-07,1.00200e-06,1.00800e-06,1.01500e-06,1.02200e-06,1.02900e-06,1.03600e-06,1.04200e-06,1.04900e-06,1.05600e-06,1.06300e-06,1.06900e-06,1.07600e-06,1.08300e-06};
epsr_mat_re_10 = {2.26559e+00,2.26275e+00,2.26006e+00,2.25756e+00,2.25514e+00,2.25285e+00,2.25067e+00,2.24860e+00,2.24662e+00,2.24477e+00,2.24298e+00,2.24126e+00,2.23963e+00,2.23806e+00,2.23657e+00,2.23515e+00,2.23378e+00,2.23247e+00,2.23120e+00,2.22999e+00,2.22882e+00,2.22772e+00,2.22664e+00,2.22561e+00,2.22461e+00,2.22365e+00,2.22272e+00,2.22184e+00,2.22098e+00,2.22015e+00,2.21935e+00,2.21857e+00,2.21782e+00,2.21711e+00,2.21640e+00,2.21572e+00,2.21507e+00,2.21443e+00,2.21381e+00,2.21322e+00,2.21264e+00,2.21208e+00,2.21153e+00,2.21100e+00,2.21048e+00,2.20999e+00,2.20950e+00,2.20903e+00,2.20857e+00,2.20812e+00,2.20769e+00,2.20727e+00,2.20685e+00,2.20645e+00,2.20606e+00,2.20568e+00,2.20531e+00,2.20494e+00,2.20459e+00,2.20424e+00,2.20390e+00,2.20357e+00,2.20326e+00,2.20294e+00,2.20263e+00,2.20233e+00,2.20203e+00,2.20175e+00,2.20147e+00,2.20119e+00,2.20092e+00,2.20066e+00,2.20040e+00,2.20014e+00,2.19989e+00,2.19965e+00,2.19941e+00,2.19917e+00,2.19894e+00,2.19872e+00,2.19850e+00,2.19828e+00,2.19806e+00,2.19785e+00,2.19764e+00,2.19744e+00,2.19724e+00,2.19704e+00,2.19684e+00,2.19667e+00,2.19647e+00,2.19628e+00,2.19609e+00,2.19591e+00,2.19575e+00,2.19557e+00,2.19539e+00,2.19522e+00,2.19507e+00,2.19490e+00,2.19473e+00};
epsr_mat_im_10 = {0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00,0.00000e+00};
lambdamat_11   = {2.16800e-07,2.17500e-07,2.18300e-07,2.19100e-07,2.19800e-07,2.20600e-07,2.21400e-07,2.22200e-07,2.23000e-07,2.23800e-07,2.24600e-07,2.25400e-07,2.26300e-07,2.27100e-07,2.27900e-07,2.28800e-07,2.29600e-07,2.30500e-07,2.31300e-07,2.32200e-07,2.33100e-07,2.33900e-07,2.34800e-07,2.35700e-07,2.36600e-07,2.37500e-07,2.38400e-07,2.39400e-07,2.40300e-07,2.41200e-07,2.42200e-07,2.43100e-07,2.44100e-07,2.45000e-07,2.46000e-07,2.47000e-07,2.48000e-07,2.49000e-07,2.50000e-07,2.51000e-07,2.52000e-07,2.53000e-07,2.54100e-07,2.55100e-07,2.56200e-07,2.57200e-07,2.58300e-07,2.59400e-07,2.60500e-07,2.61600e-07,2.62700e-07,2.63800e-07,2.64900e-07,2.66100e-07,2.67200e-07,2.68400e-07,2.69500e-07,2.70700e-07,2.71900e-07,2.73100e-07,2.74300e-07,2.75500e-07,2.76800e-07,2.78000e-07,2.79200e-07,2.80500e-07,2.81800e-07,2.83100e-07,2.84400e-07,2.85700e-07,2.87000e-07,2.88300e-07,2.89700e-07,2.91000e-07,2.92400e-07,2.93800e-07,2.95200e-07,2.96600e-07,2.98000e-07,2.99500e-07,3.00900e-07,3.02400e-07,3.03900e-07,3.05400e-07,3.06900e-07,3.08400e-07,3.10000e-07,3.11500e-07,3.13100e-07,3.14700e-07,3.16300e-07,3.17900e-07,3.19500e-07,3.21200e-07,3.22900e-07,3.24600e-07,3.26300e-07,3.28000e-07,3.29700e-07,3.31500e-07,3.33300e-07,3.35100e-07,3.36900e-07,3.38800e-07,3.40600e-07,3.42500e-07,3.44400e-07,3.46300e-07,3.48300e-07,3.50200e-07,3.52200e-07,3.54200e-07,3.56300e-07,3.58300e-07,3.60400e-07,3.62500e-07,3.64700e-07,3.66800e-07,3.69000e-07,3.71200e-07,3.73400e-07,3.75700e-07,3.78000e-07,3.80300e-07,3.82700e-07,3.85000e-07,3.87500e-07,3.89900e-07,3.92400e-07,3.94900e-07,3.97400e-07,4.00000e-07,4.02500e-07,4.05200e-07,4.07800e-07,4.10500e-07,4.13300e-07,4.16100e-07,4.18900e-07,4.21700e-07,4.24600e-07,4.27500e-07,4.30500e-07,4.33500e-07,4.36600e-07,4.39700e-07,4.42800e-07,4.46000e-07,4.49200e-07,4.52500e-07,4.55800e-07,4.59200e-07,4.62600e-07,4.66100e-07,4.69600e-07,4.73200e-07,4.76900e-07,4.80600e-07,4.84300e-07,4.88100e-07,4.92000e-07,4.95900e-07,4.99900e-07,5.04000e-07,5.08100e-07,5.12300e-07,5.16600e-07,5.20900e-07,5.25400e-07,5.29900e-07,5.34400e-07,5.39100e-07,5.43800e-07,5.48600e-07,5.53500e-07,5.58500e-07,5.63600e-07,5.68700e-07,5.74000e-07,5.79400e-07,5.84800e-07,5.90400e-07,5.96100e-07,6.01900e-07,6.07800e-07,6.13800e-07,6.19900e-07,6.26200e-07,6.32600e-07,6.39100e-07,6.45800e-07,6.52600e-07,6.59500e-07,6.66600e-07,6.73800e-07,6.81200e-07,6.88800e-07,6.96500e-07,7.04500e-07,7.12600e-07,7.20800e-07,7.29300e-07,7.38000e-07,7.46900e-07,7.56000e-07,7.65300e-07,7.74900e-07,7.84700e-07,7.94800e-07,8.05100e-07,8.15700e-07,8.26600e-07,8.85600e-07,9.53700e-07,9.68600e-07,9.84000e-07,9.99900e-07,1.01600e-06,1.03300e-06,1.05100e-06,1.06900e-06,1.08800e-06,1.10700e-06,1.12000e-06,1.12700e-06,1.14400e-06,1.14800e-06,1.17000e-06,1.20000e-06};
epsr_mat_re_11 = {-8.24178e+00,-8.29214e+00,-8.40020e+00,-8.45598e+00,-8.54928e+00,-8.65087e+00,-8.72343e+00,-8.81976e+00,-8.89162e+00,-8.98589e+00,-9.05146e+00,-9.10760e+00,-9.16072e+00,-9.18623e+00,-9.21744e+00,-9.19486e+00,-9.16612e+00,-9.08742e+00,-9.01475e+00,-8.92019e+00,-8.82381e+00,-8.74937e+00,-8.68349e+00,-8.65424e+00,-8.65105e+00,-8.66794e+00,-8.72440e+00,-8.79437e+00,-8.89465e+00,-8.99208e+00,-9.14014e+00,-9.29000e+00,-9.44450e+00,-9.62777e+00,-9.81939e+00,-1.00203e+01,-1.02443e+01,-1.04650e+01,-1.06950e+01,-1.09598e+01,-1.12254e+01,-1.15046e+01,-1.17709e+01,-1.20893e+01,-1.24008e+01,-1.27297e+01,-1.30835e+01,-1.34500e+01,-1.38489e+01,-1.42798e+01,-1.47154e+01,-1.51896e+01,-1.57041e+01,-1.62369e+01,-1.67922e+01,-1.73548e+01,-1.79315e+01,-1.84562e+01,-1.89332e+01,-1.93437e+01,-1.96392e+01,-1.98193e+01,-1.98867e+01,-1.98124e+01,-1.96102e+01,-1.92877e+01,-1.88239e+01,-1.82164e+01,-1.74503e+01,-1.63333e+01,-1.47679e+01,-1.24106e+01,-9.45548e+00,-6.12934e+00,-2.93152e+00,-6.73190e-02,2.37222e+00,4.34308e+00,5.97830e+00,7.31638e+00,8.42475e+00,9.36796e+00,1.01172e+01,1.07756e+01,1.13419e+01,1.18277e+01,1.22335e+01,1.26362e+01,1.30106e+01,1.33320e+01,1.36551e+01,1.39645e+01,1.42543e+01,1.45652e+01,1.48910e+01,1.52122e+01,1.55291e+01,1.58485e+01,1.61746e+01,1.65346e+01,1.68777e+01,1.72330e+01,1.75865e+01,1.79552e+01,1.83213e+01,1.87081e+01,1.91254e+01,1.95746e+01,2.00724e+01,2.06812e+01,2.14212e+01,2.23879e+01,2.37106e+01,2.56007e+01,2.81836e+01,3.14907e+01,3.52195e+01,3.87911e+01,4.14811e+01,4.31383e+01,4.37395e+01,4.32656e+01,4.21301e+01,4.07353e+01,3.92276e+01,3.77444e+01,3.63509e+01,3.50640e+01,3.38739e+01,3.27856e+01,3.17947e+01,3.08751e+01,3.00470e+01,2.92682e+01,2.85138e+01,2.78360e+01,2.71969e+01,2.66019e+01,2.60423e+01,2.55314e+01,2.50456e+01,2.45703e+01,2.41294e+01,2.37022e+01,2.33043e+01,2.29248e+01,2.25644e+01,2.22373e+01,2.18989e+01,2.15862e+01,2.12811e+01,2.09870e+01,2.07126e+01,2.04305e+01,2.01906e+01,1.99308e+01,1.97233e+01,1.94922e+01,1.92740e+01,1.90644e+01,1.88557e+01,1.86571e+01,1.84675e+01,1.82884e+01,1.80998e+01,1.79316e+01,1.77626e+01,1.76033e+01,1.74445e+01,1.72954e+01,1.71376e+01,1.69968e+01,1.68573e+01,1.67180e+01,1.65883e+01,1.64578e+01,1.63367e+01,1.62075e+01,1.60952e+01,1.59753e+01,1.58634e+01,1.57521e+01,1.56492e+01,1.55466e+01,1.54521e+01,1.53501e+01,1.52564e+01,1.51550e+01,1.50696e+01,1.49766e+01,1.48839e+01,1.47992e+01,1.47223e+01,1.46381e+01,1.45540e+01,1.44779e+01,1.44094e+01,1.43412e+01,1.42731e+01,1.41977e+01,1.41450e+01,1.40774e+01,1.40249e+01,1.39576e+01,1.38979e+01,1.38458e+01,1.37937e+01,1.37270e+01,1.36678e+01,1.36013e+01,1.35497e+01,1.34909e+01,1.32001e+01,1.29319e+01,1.28809e+01,1.28314e+01,1.27835e+01,1.27378e+01,1.26928e+01,1.26480e+01,1.26061e+01,1.25656e+01,1.25281e+01,1.25040e+01,1.24913e+01,1.24574e+01,1.24560e+01,1.24228e+01,1.23855e+01};
epsr_mat_im_11 = {7.28970e+00,7.34432e+00,7.49265e+00,7.62930e+00,7.74504e+00,7.87930e+00,7.99576e+00,8.16684e+00,8.30720e+00,8.48767e+00,8.66583e+00,8.84936e+00,9.04096e+00,9.26185e+00,9.48720e+00,9.70751e+00,9.90277e+00,1.01175e+01,1.02791e+01,1.04149e+01,1.05173e+01,1.05888e+01,1.06068e+01,1.06339e+01,1.06406e+01,1.06568e+01,1.06590e+01,1.06674e+01,1.06817e+01,1.07025e+01,1.07216e+01,1.07739e+01,1.08361e+01,1.09108e+01,1.09885e+01,1.10866e+01,1.11941e+01,1.13337e+01,1.14771e+01,1.16266e+01,1.18020e+01,1.19743e+01,1.21854e+01,1.24101e+01,1.26410e+01,1.29074e+01,1.31944e+01,1.34877e+01,1.38338e+01,1.42145e+01,1.46290e+01,1.50928e+01,1.56078e+01,1.62080e+01,1.68885e+01,1.76899e+01,1.85997e+01,1.96182e+01,2.07537e+01,2.20406e+01,2.34415e+01,2.49120e+01,2.64813e+01,2.81124e+01,2.97862e+01,3.15482e+01,3.33466e+01,3.52671e+01,3.72916e+01,3.95016e+01,4.18694e+01,4.40879e+01,4.57794e+01,4.66799e+01,4.67569e+01,4.62433e+01,4.53509e+01,4.42714e+01,4.31506e+01,4.20316e+01,4.09581e+01,3.99492e+01,3.90132e+01,3.81319e+01,3.73339e+01,3.66095e+01,3.59417e+01,3.53535e+01,3.48395e+01,3.43517e+01,3.39413e+01,3.35671e+01,3.32390e+01,3.29399e+01,3.26794e+01,3.24439e+01,3.22337e+01,3.20383e+01,3.18743e+01,3.17437e+01,3.16152e+01,3.15341e+01,3.14780e+01,3.14426e+01,3.14592e+01,3.15134e+01,3.16383e+01,3.18346e+01,3.21257e+01,3.25323e+01,3.30790e+01,3.38171e+01,3.46961e+01,3.56351e+01,3.63148e+01,3.63467e+01,3.52840e+01,3.28858e+01,2.94810e+01,2.55405e+01,2.14440e+01,1.77252e+01,1.46187e+01,1.21943e+01,1.02951e+01,8.83218e+00,7.63812e+00,6.67366e+00,5.90042e+00,5.23853e+00,4.70413e+00,4.31118e+00,3.90003e+00,3.56636e+00,3.34847e+00,3.07529e+00,2.80944e+00,2.63364e+00,2.49319e+00,2.30645e+00,2.11380e+00,2.01417e+00,1.90741e+00,1.80264e+00,1.78747e+00,1.62894e+00,1.54948e+00,1.40596e+00,1.39524e+00,1.23637e+00,1.20913e+00,1.19158e+00,1.19289e+00,1.21190e+00,1.07880e+00,1.07184e+00,7.99560e-01,8.30208e-01,7.28906e-01,6.89986e-01,6.68822e-01,6.30720e-01,6.27508e-01,5.64564e-01,6.12720e-01,5.08200e-01,5.05800e-01,4.69952e-01,4.42762e-01,3.57674e-01,3.72600e-01,3.95808e-01,3.61328e-01,3.59832e-01,2.60672e-01,3.08332e-01,2.58688e-01,2.73768e-01,2.40720e-01,2.15838e-01,2.38980e-01,2.38140e-01,2.13624e-01,1.97150e-01,1.96550e-01,1.88064e-01,1.71864e-01,1.71292e-01,1.47516e-01,1.39320e-01,1.31172e-01,1.23104e-01,1.22784e-01,1.14780e-01,1.06820e-01,9.89300e-02,9.86960e-02,9.84620e-02,9.06720e-02,8.28960e-02,8.27420e-02,7.50400e-02,7.49000e-02,6.72480e-02,6.71040e-02,5.95360e-02,5.94240e-02,5.18700e-02,5.17580e-02,4.42560e-02,4.41720e-02,3.67300e-02,5.63146e-02,1.62544e-02,4.59392e-03,3.65374e-03,2.86032e-03,1.99864e-03,1.28257e-03,8.53536e-04,4.75767e-04,2.97763e-04,1.76975e-04,1.13155e-04,9.18918e-05,4.80012e-05,4.09399e-05,1.05738e-05,0.00000e+00};
lambdamat_12   = {2.50000e-07,2.60000e-07,2.70000e-07,2.80000e-07,2.90000e-07,3.00000e-07,3.10000e-07,3.20000e-07,3.30000e-07,3.40000e-07,3.50000e-07,3.60000e-07,3.70000e-07,3.80000e-07,3.90000e-07,4.00000e-07,4.10000e-07,4.20000e-07,4.30000e-07,4.40000e-07,4.50000e-07,4.60000e-07,4.70000e-07,4.80000e-07,4.90000e-07,5.00000e-07,5.10000e-07,5.20000e-07,5.30000e-07,5.40000e-07,5.50000e-07,5.60000e-07,5.70000e-07,5.80000e-07,5.90000e-07,6.00000e-07,6.10000e-07,6.20000e-07,6.30000e-07,6.40000e-07,6.50000e-07,6.60000e-07,6.70000e-07,6.80000e-07,6.90000e-07,7.00000e-07,7.10000e-07,7.20000e-07,7.30000e-07,7.40000e-07,7.50000e-07,7.60000e-07,7.70000e-07,7.80000e-07,7.90000e-07,8.00000e-07,8.10000e-07,8.20000e-07,8.30000e-07,8.40000e-07,8.50000e-07};
epsr_mat_re_12 = {5.48000e+00,5.51439e+00,5.50484e+00,5.46456e+00,5.40327e+00,5.32812e+00,5.24428e+00,5.15554e+00,5.06459e+00,4.97337e+00,4.88323e+00,4.79511e+00,4.70963e+00,4.62720e+00,4.54804e+00,4.47226e+00,4.39991e+00,4.33095e+00,4.26530e+00,4.20285e+00,4.14350e+00,4.08711e+00,4.03352e+00,3.98262e+00,3.93425e+00,3.88829e+00,3.84459e+00,3.80304e+00,3.76352e+00,3.72589e+00,3.69007e+00,3.65594e+00,3.62341e+00,3.59239e+00,3.56279e+00,3.53453e+00,3.50754e+00,3.48174e+00,3.45706e+00,3.43346e+00,3.41086e+00,3.38922e+00,3.36848e+00,3.34859e+00,3.32951e+00,3.31120e+00,3.29362e+00,3.27672e+00,3.26049e+00,3.24487e+00,3.22985e+00,3.21538e+00,3.20145e+00,3.18804e+00,3.17510e+00,3.16263e+00,3.15060e+00,3.13899e+00,3.12778e+00,3.11695e+00,3.10649e+00};
epsr_mat_im_12 = {9.93483e-01,8.48454e-01,7.26134e-01,6.23625e-01,5.38097e-01,4.66970e-01,4.07980e-01,3.59180e-01,3.18920e-01,2.85812e-01,2.58693e-01,2.36592e-01,2.18698e-01,2.04335e-01,1.92940e-01,1.84039e-01,1.77239e-01,1.72209e-01,1.68670e-01,1.66389e-01,1.65170e-01,1.64844e-01,1.65273e-01,1.66337e-01,1.67933e-01,1.69978e-01,1.72396e-01,1.75126e-01,1.78114e-01,1.81314e-01,1.84688e-01,1.88203e-01,1.91829e-01,1.95542e-01,1.99321e-01,2.03149e-01,2.07009e-01,2.10888e-01,2.14776e-01,2.18662e-01,2.22539e-01,2.26398e-01,2.30235e-01,2.34044e-01,2.37821e-01,2.41563e-01,2.45266e-01,2.48928e-01,2.52547e-01,2.56121e-01,2.59650e-01,2.63132e-01,2.66566e-01,2.69953e-01,2.73291e-01,2.76580e-01,2.79821e-01,2.83014e-01,2.86159e-01,2.89256e-01,2.92305e-01};
lambdamat_13   = {1.90700e-07,2.06600e-07,2.13800e-07,2.11400e-07,2.29600e-07,2.38400e-07,2.48000e-07,2.58300e-07,2.69500e-07,2.81800e-07,2.95200e-07,3.09900e-07,3.26300e-07,3.44400e-07,3.64600e-07,3.87400e-07,4.13300e-07,4.42800e-07,4.76800e-07,5.16600e-07,5.39000e-07,5.63500e-07,5.90400e-07,6.19900e-07,6.52500e-07,6.70200e-07,6.88000e-07,7.08400e-07,7.29300e-07,8.26500e-07,1.24000e-06,1.26500e-06,1.29100e-06,1.31900e-06,1.34800e-06,1.37800e-06,1.40900e-06,1.44200e-06,1.47600e-06,1.51200e-06,1.55000e-06,1.58900e-06,1.63100e-06,1.67500e-06,1.72200e-06,1.77100e-06,1.82300e-06,1.87800e-06,1.93700e-06,2.00000e-06,2.06600e-06,2.13800e-06,2.21400e-06,2.29600e-06,2.38400e-06,2.48000e-06,2.58300e-06,2.69500e-06,2.81800e-06,2.95200e-06,3.10000e-06,3.26300e-06,3.44400e-06,3.64600e-06};
epsr_mat_re_13 = {-9.59136e-01,-1.44650e+00,-1.57890e+00,-1.63520e+00,-1.53000e+00,-1.33560e+00,-1.00750e+00,-5.83200e-01,-4.78500e-01,-4.69500e-01,-6.73200e-01,-1.16280e+00,-1.48050e+00,-1.78080e+00,-2.18960e+00,-3.49170e+00,-3.49170e+00,-4.20070e+00,-4.92750e+00,-5.50560e+00,-5.62650e+00,-6.07772e+00,-7.67708e+00,-1.04236e+01,-1.34231e+01,-1.48534e+01,-1.63571e+01,-1.79318e+01,-1.95752e+01,-2.76000e+01,-7.13841e+01,-4.57224e+01,-4.76314e+01,-4.95784e+01,-5.17085e+01,-5.38823e+01,-5.64017e+01,-5.89775e+01,-6.17672e+01,-6.46202e+01,-6.78604e+01,-7.13478e+01,-7.50949e+01,-7.91148e+01,-8.34198e+01,-8.80254e+01,-9.31369e+01,-9.87894e+01,-1.05426e+02,-1.11638e+02,-1.20208e+02,-1.26820e+02,-1.38280e+02,-1.47779e+02,-1.60102e+02,-1.72917e+02,-1.86202e+02,-2.05696e+02,-2.23123e+02,-2.44329e+02,-2.69722e+02,-2.99767e+02,-3.34950e+02,-3.79792e+02};
epsr_mat_im_13 = {2.62492e+00,3.30720e+00,3.67400e+00,4.10640e+00,4.55680e+00,4.96800e+00,5.23320e+00,5.23260e+00,5.07680e+00,4.88720e+00,4.65760e+00,4.60960e+00,4.85080e+00,4.89940e+00,4.95300e+00,5.21560e+00,5.21560e+00,5.52240e+00,5.75000e+00,5.82400e+00,5.38720e+00,4.29520e+00,2.63016e+00,1.76256e+00,1.57076e+00,1.65980e+00,1.72530e+00,1.81472e+00,1.97578e+00,2.73520e+00,7.32636e+00,6.72576e+00,6.98920e+00,7.27180e+00,7.57050e+00,7.88992e+00,8.23782e+00,8.60860e+00,9.01472e+00,9.44632e+00,1.00111e+01,1.06214e+01,1.12796e+01,1.19885e+01,1.27690e+01,1.36069e+01,1.45587e+01,1.55931e+01,1.67890e+01,1.80200e+01,1.95800e+01,2.10858e+01,2.31280e+01,2.51320e+01,2.76860e+01,3.03600e+01,3.34280e+01,3.71520e+01,4.11000e+01,4.61580e+01,5.24700e+01,6.02040e+01,6.99200e+01,8.19280e+01};
lambdamat_14   = {1e-9,50e-6};
epsr_mat_re_14 = {epsr_custom_1_re,epsr_custom_1_re};
epsr_mat_im_14 = {epsr_custom_1_im,epsr_custom_1_im};
lambdamat_15   = {1e-9,50e-6};
epsr_mat_re_15 = {epsr_custom_2_re,epsr_custom_2_re};
epsr_mat_im_15 = {epsr_custom_2_im,epsr_custom_2_im};
lambdamat_16   = {1e-9,50e-6};
epsr_mat_re_16 = {epsr_custom_3_re,epsr_custom_3_re};
epsr_mat_im_16 = {epsr_custom_3_im,epsr_custom_3_im};

